%store the results for all simulations
res_all = zeros(10, 1);

%m denotes the number of agents and n denotes the number of items
m = 20; n = 6;

%valuation; V(i, j) denotes the value of the ith item to the jth agent
V = [[1.05, 14.61, 0.05, 5.09, 0, 6.7, 5.01, 1.91, 9.21, 0.05, 0, 1.06, 0.05, 0.2, 3.5, 13.05, 0, 0, 3.02, 0.05], 
[1.93, 17.45, 0.1, 5.42, 0, 5, 2.2, 2.91, 0, 0.05, 0.57, 1.5, 0.05, 0, 0.29, 2, 0, 10, 4.99, 0.05], 
[0, 24.64, 0.05, 15.4, 26.03, 26.08, 4.49, 4.05, 11.58, 0.05, 0.57, 3.1, 0.05, 0.2, 0.85, 2, 0.05, 7, 4.03, 0.05], 
[0, 27.95, 0.2, 12.36, 2.01, 0.9, 8.68, 4.32, 10.27, 0.05, 0.57, 1.37, 0.05, 0.2, 1.67, 5.05, 0.5, 6.1, 2.04, 0.05], 
[0.56, 4.41, 0.1, 5.83, 4.85, 0, 2.49, 4.37, 0, 4, 0.77, 1.65, 2, 0.2, 4.41, 8, 0.95, 0, 2.05, 2], 
[1.25, 21.71, 8, 13.21, 10.52, 10, 7.23, 5.04, 11.1, 0.05, 0.57, 3.2, 0.05, 0.2, 0.05, 3, 10.51, 10, 5.15, 0]];

%we do ten simulations in total, with seeds from 1 to 10
for seed = 1 : 10
    rng(seed)
    %set random budget constraint
    budget = rand(m, 1) * 10;
    %all-one vectors of length n and m, respectively
    onesn = ones(n, 1);
    onesm = ones(m, 1);
    %ultimate result; initiate with 1
    res = 1;

    %iterate through all agents
    %ind = i indicates that the ith agent imposes a diversity constraint
    for ind = 1 : m

        %use convex optimization solver to compute the optimal allocation without diversity constraint
        cvx_begin
            %allocation; x(i, j) denotes the allocation of the ith item to the jth agent
            variable x(n, m);
            %maximize(sum(((x .* V)' * onesn).^0.1)); %Implements gamma-fairness for gamma = 0.1
            %maximize(sum(((x .* V)' * onesn).^0.5)); %implements gamma-fairness for gamma = 0.5
            %maximize(sum((x .* V)' * onesn)); %implements social welfare
            maximize(sum(log((x .* V)' * onesn))); %implements nash welfare
            subject to
                0 <= x; %constraint: allocation is nonnegative
                x <= 1; %constraint: each individual allocation is no greater than 1
                x * onesm <= onesn; %constraint: the sum of allocation of one item is no greater than 1
                (x .* V)' * onesn <= budget %budget constraint
        cvx_end

        %use convex optimization solver to compute the optimal allocation with diversity constraint
        cvx_begin
            variable y(n, m);
            %maximize(sum(((y .* V)' * onesn).^0.1)); %Implements gamma-fairness for gamma = 0.1
            %maximize(sum(((y .* V)' * onesn).^0.5)); %implements gamma-fairness for gamma = 0.5
            %maximize(sum((y .* V)' * onesn)); %implements social welfare
            maximize(sum(log((y .* V)' * onesn))); %implements nash welfare
            subject to
                0 <= y; %constraint: allocation is nonnegative
                y <= 1; %constraint: each individual allocation is no greater than 1
                y * onesm <= onesn; %constraint: the sum of allocation of one item is no greater than 1

                %diversity constraint: equalize the allocation of all
                %items for the ind^th agent; if the value of an item for this agent is 0, then
                %we will ignore this item for this agent (that is, do not 
                %require the allocation of this item to be equal to the others)
                V(1, ind) * V(2, ind) * y(1, ind) ==  V(1, ind) * V(2, ind) * y(2, ind);
                V(1, ind) * V(3, ind) * y(1, ind) ==  V(1, ind) * V(3, ind) * y(3, ind);
                V(1, ind) * V(4, ind) * y(1, ind) ==  V(1, ind) * V(4, ind) * y(4, ind);
                V(1, ind) * V(5, ind) * y(1, ind) ==  V(1, ind) * V(5, ind) * y(5, ind);
                V(1, ind) * V(6, ind) * y(1, ind) ==  V(1, ind) * V(6, ind) * y(6, ind);
                V(2, ind) * V(3, ind) * y(2, ind) ==  V(2, ind) * V(3, ind) * y(3, ind);
                V(2, ind) * V(4, ind) * y(2, ind) ==  V(2, ind) * V(4, ind) * y(4, ind);
                V(2, ind) * V(5, ind) * y(2, ind) ==  V(2, ind) * V(5, ind) * y(5, ind);
                V(2, ind) * V(6, ind) * y(2, ind) ==  V(2, ind) * V(6, ind) * y(6, ind);
                V(3, ind) * V(4, ind) * y(3, ind) ==  V(3, ind) * V(4, ind) * y(4, ind);
                V(3, ind) * V(5, ind) * y(3, ind) ==  V(3, ind) * V(5, ind) * y(5, ind);
                V(3, ind) * V(6, ind) * y(3, ind) ==  V(3, ind) * V(6, ind) * y(6, ind);
                V(4, ind) * V(5, ind) * y(4, ind) ==  V(4, ind) * V(5, ind) * y(5, ind);
                V(4, ind) * V(6, ind) * y(4, ind) ==  V(4, ind) * V(6, ind) * y(6, ind);
                V(5, ind) * V(6, ind) * y(5, ind) ==  V(5, ind) * V(6, ind) * y(6, ind);

                (y .* V)' * onesn <= budget %budget constraint
        cvx_end

        XV = x .* V; %ultimate valuation without diversity constraint
        YV = y .* V; %ultimate valuation with diversity constraint

        %compute the maximum p such that it satisfies p-MON
        orig = sum(XV( : ,ind));
        after = sum(YV( : ,ind));
        p = orig / after;

        res = min(res, p);
    end
    
    res_all(seed, 1) = res;
end